---
generated_at: 2026-01-22 12:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：319-GraphQL Explorer

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/api/graphql/graphql_explorer_controller.rb`
- E-02: `app/views/api/graphql/graphql_explorer/show.html.haml`
- E-03: `config/routes/api.rb`
- E-04: `画面機能マッピング.csv` (381行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは `/-/graphql-explorer` である | E-03 (6行目) | ○ |
| C-02 | コントローラは `API::Graphql::GraphqlExplorerController#show` | E-01, E-03 | ○ |
| C-03 | Gitlab::GonHelperをインクルード | E-01 (6行目) | ○ |
| C-04 | WithPerformanceBarをインクルード | E-01 (7行目) | ○ |
| C-05 | add_gon_variablesを呼び出す | E-01 (11行目) | ○ |
| C-06 | HTML5ドキュメントとしてレンダリング | E-02 (1行目) | ○ |
| C-07 | CSRFトークンを含む | E-02 (6行目) | ○ |
| C-08 | Action Cable設定を含む | E-02 (7行目) | ○ |
| C-09 | Gon::Base.render_dataでクライアント設定を渡す | E-02 (8行目) | ○ |
| C-10 | パフォーマンスバー有効時にクラスを追加 | E-02 (12行目) | ○ |
| C-11 | パフォーマンスバーをレンダリング（有効時） | E-02 (13-20行目) | ○ |
| C-12 | graphiql-containerにGraphiQLをマウント | E-02 (21行目) | ○ |
| C-13 | GraphQL APIエンドポイントは `/api/graphql` | E-03 (4行目) | ○ |
| C-14 | 関連機能はGraphQL API（機能No.101） | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に明確な根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] GraphiQLの動作確認
- [ ] 認証済み/未認証でのアクセス確認
- [ ] パフォーマンスバー有効時の表示確認
